#ifndef CRITTER_H
#define CRITTER_H
#include "stdafx.h"
#include "vector1.h" //for Vector2 type
#include "cMemoryDC3A.h" //for cMemoryDC type
#include "world1.h" //for Box2 type
#include "frame1.h" //for Frame type
#include <afxtempl.h> //For CArray

//----------compiler switch
//#define UDPATE_NORMALIZE

#define CRIT_WANDER 0
#define CRIT_GRAVITY 1
#define CRIT_SPRING 2
//==========Defines
#define MIN_SPEED 0.01
#define MAX_SPEED 10.0
/*#define CR_PREY 0
#define CR_PREDATOR 1
#define CR_NEUTRAL 2
*/
#define PREY_VALUE 1
#define PREDATOR_VALUE -1
#define DART_FACTOR 100.0
#define CATCH_FACTOR 0.75

//==============================Critter==============================
class OwnerCritterList; //Forward declaration so Critter can mention it.

class Critter 
{
protected:
	World *_world;
	cTransparentMemoryDC *_icon;
	cTransparentMemoryDC *_icon_fullsize;
	Real _scalex, _scaley;
	OwnerCritterList *_owner;
	int _owner_index; //position in the _owner OwnerCritterList.
	BOOL _alive;
	CPoint _point_position;
	Vector2 _position;
	Vector2 _direction; //Unit vector tangent to the direction of motion.
	Real _speed; //We will use _speed*_direction as the _velocity vector.
	Real _minspeed, _maxspeed; //Some reasonable bounds.
	Vector2 _velocity; //Keep _velocity = _speed * _direction
	Vector2 _acceleration; // Will use for force fields.
	Real	_mass; // Will use for force fields because accel = force / mass.
	Real _radius; // Use for colliding, to tell if you are close enough.
	int _score;
	BOOL _RealToPixel(const Frame &frame); //helper function
	friend OwnerCritterList; //so OwnerCritterList can easily adjust _owner
		//and _owner_index.
public:
	//---------------Constructor-----------------------
	Critter();
	~Critter(){delete _icon;} //_icon is allocated in the constructor with a new.
	//---------------Accessors---------------------------
	World* world()const{return _world;}
	cMemoryDC* icon()const{return _icon;}
	BOOL alive(){return _alive;}
	OwnerCritterList* owner(){return _owner;}
	int owner_index(){return _owner_index;}
	CPoint point_position()const{return _point_position;}
	Vector2 position()const{return _position;}
	Vector2 direction()const{return _direction;}
	Real speed()const{return _speed;}
	Real minspeed()const{return _minspeed;}
	Real maxspeed()const{return _maxspeed;}
	Vector2 velocity()const{return _velocity;}
	Vector2 acceleration()const{return _acceleration;}
	Real mass()const{return _mass;}
	Real radius()const{return _radius;}
	int score()const{return _score;}
	int value(Critter * othercritter);	
//---------------Mutators---------------------------
	void SetWorld(World *world){_world = world;}
	void SetIcon(cTransparentMemoryDC *icon);
	void scaleIcon(Real scalefactor_x, Real scalefactor_y);
	void SetPosition(Vector2 position){_position = position;}
	void SetRadius(Real radius){_radius = radius;}
	void SetMaxSpeed(Real maxspeed){_maxspeed = maxspeed;}
	void RandomizePositionVelocity();
	int bumpScore(int d_score){return(_score += d_score);}
	//---------------Methods-----------------------------
	virtual void Move();
	virtual void Collide(Critter *othercritter);
	void Show(CDC *pDC, const Frame &frame);
	//------------Child Method Prototypes----------
	virtual Real CursorMoveResponse(){return 0.0;}
	virtual void SetCursorMoveResponse(Real val){}
	virtual void Add(Critter *critter){}
	virtual void AddSpring(Critter *critter){}
	virtual void AddGravity(Critter *critter){}
	virtual Real SpringConstant(){return 0.0;}
	virtual void SetSpringConstant(Real val){}
	virtual Real GravityConstant(){return 0.0;}
	virtual void SetGravityConstant(Real val){}
	virtual Real PredatorForce(){return 0.0;}
	virtual void SetPredatorForce(Real val){}
	virtual Real PreyForce(){return 0.0;}
	virtual void SetPreyForce(Real val){}
	virtual void AddPredator(Critter *critter){}
	virtual void AddPrey(Critter *critter){}
};

//====================Metric class ============
class cMetricEntry
{
private:
	Real _rDistance;
	Vector2 _v2Direction;
	friend class cMetric;
public:
	cMetricEntry():_rDistance(0.0), _v2Direction(1.0,0){}
};

class cMetric
{
private:
	/* We are going to use a cMetric like a double array.  It's not easy to
	get a double array to work as a CArray, so to make life easy we just
	build in an _index function, and instead of trying to have a double
	array _cMetricEntry where we would access _metric2[i][j], we instead use
	a single array _cMetricEntry and access _cMetricEntry[_index(i,j)]. */ 
	CArray<cMetricEntry, cMetricEntry &> _cArrayMetricEntry;
	int _index(int i, int j) const;
	class OwnerCritterList* _pOwnerCritterList;
public:
	void setOwnerCritterList(OwnerCritterList* _pOwnerCritterList_new);
	void update();
	void updateAndNormalize();
	Real distance(int i, int j) const;
	Vector2 direction(int i, int j) const;
};	
//====================Ecology class===========
class cEcology
{
private: 
	/* We are going to use a cEcology like a double array.  It's not easy to
	get a double array to work as a CArray, so to make life easy we just
	build in an _index function, and instead of trying to have a double
	array _cEcologyEntry where we would access _Ecology2[i][j], we instead use
	a single array _cEcologyEntry and access _cEcologyEntry[_index(i,j)]. */ 
	CArray<int, int &> _cArrayEcology;
	int _index(int i, int j) const;
	class OwnerCritterList* _pOwnerCritterList;
public:
	cEcology(){}
	void setOwnerCritterList(OwnerCritterList* _pOwnerCritterList_new);
	int value(int i, int j) const;
	void setValue(int i, int j, int val);
};	

//==================OwnerCritterList========================

class OwnerCritterList
{
protected:
	/* The CArray template likes two types as argument, the first type is the
	type of the object in the array, the second is the way you like to pass
	the object, one often see CArray<Type, const Type &>.  When Type is something
	simple like a pointer or a Real (which means float or double) we don't
	need to pass the arguments in an alternate way. */
	CArray <Critter *, Critter *> _critter; 
	Critter *_focus;
	cMetric _metric;
	cEcology _ecology;
public:
	//-------------Constructors---------------
	OwnerCritterList():_focus(NULL){}
	~OwnerCritterList();   /* The OwnerCritterList destructor *does*
		destroy the _critter[i]* by calling delete on them. */
	//-------------Mutators--------------------
	void SetWorld(World *world);
	void RandomizePositionVelocity();
	void Add(Critter *critter);  // Sets  critter->_owner = this.
	void SetFocusCritter(Critter *critter){_focus = critter;}
	Critter* SetFocusByCursor(); //Set _focus to _critter[i] closest to cursor.
	void scaleIcon(Real scalefactor_x, Real scalefactor_y);
	void setValue(int i, int j, int val){ _ecology.setValue( i,  j,  val);}
 	//-------------Accessors--------------------
	World* world()const{return _critter[0]->world();}
	int size()const {return _critter.GetSize();}
	Critter* Focus()const{return _focus;} 
  	Critter*& operator[](int index); /* Return the _critter[index]
		pointer.  We return it as a reference so we can use this on the 
		left hand as well as on the right hand of an =. */
	Critter* ClosestCritter(Critter *basecritter) const;
	Critter* ClosestCritter( Critter *basecritter,
		const CArray<Critter*, Critter*> &critterlist) const;
	Critter* ClosestCritter(const Vector2 &location) const;
	int value(Critter *critteri, Critter *critterj);
	//-------------Methods-----------------------
	void Move();
	void updateMetric();
	BOOL Collide();
	void updateAndNormalizeMetric();
	void Show(CDC *pDC, const Frame &frame);
	Real distance(Critter *critteri, Critter *critterj) const;
	Vector2 direction(Critter *critteri, Critter *critterj) const;
};

//===============Child Critters=============================

class CursorCritter:public Critter
{
protected: 
/* This is the  percent of a requested cursor move that you do per update.
Usually we use a value of about 0.1.  If you request a large cursor move you 
still get a smaller effective move, but it's scaled down by this percent and it
takes several updates to complete the move to the desired position.  Note
that this isn't the same as clamping the move size. This instead has the effect 
that as you get closer to your target you slow down.  Bungy!  (Idea from Rudy 
Rucker, Jr.).
A value of 1.0 means the critter tracks the cursor exactly.  Between 0 and 1
means it follows the cursor as if by a spring (but with no accumulated momentum 
in other directions), negative would make it avoid the cursor, greater than 1 
means it would continually overcorrect in a no doubt annoying fashion. */
	Real _cursor_move_response;
public:
	CursorCritter();
	virtual Real CursorMoveResponse(){return _cursor_move_response;}
	virtual void SetCursorMoveResponse(Real val){_cursor_move_response = val;}
	virtual void Move();
};

class FixedCritter : public Critter
{
public:
	FixedCritter(){}
	virtual void Move(){}
};

class WanderCritter : public Critter
{
protected:
	Real _max_direction_change;
	Real _max_speed_change;
	Real _change_time;
public:
	WanderCritter();
	virtual void Move();
};
class SpringCritter : public Critter
{
protected:
	CArray <Critter*, Critter*> _pull_critter;
	Real _spring_constant;
public:
 	SpringCritter();
	virtual Real SpringConstant(){return _spring_constant;}
	virtual void SetSpringConstant(Real val){_spring_constant = val;}
	virtual void Add(Critter *critter){_pull_critter.Add(critter);}
	virtual void Move();
};

class GravityCritter: public Critter
{
protected:
	CArray <Critter*, Critter*> _pull_critter;
	Real _spring_constant;
	Real _gravity_constant;
	Real _repelling_force;
public:
 	GravityCritter();
	virtual Real GravityConstant(){return _gravity_constant;}
	virtual void SetGravityConstant(Real val){_gravity_constant = val;}
	virtual void Add(Critter *critter){_pull_critter.Add(critter);}
	virtual void Move();
};

class SpringGravityCritter: public Critter
{
protected:
	CArray <Critter*, Critter*> _spring_pull_critter;
	CArray <Critter*, Critter*> _gravity_pull_critter;
	Real _spring_constant;
	Real _gravity_constant;
	Real _repelling_force;
public:
	SpringGravityCritter();
	virtual Real SpringConstant(){return _spring_constant;}
	virtual void SetSpringConstant(Real val){_spring_constant = val;}
	virtual Real GravityConstant(){return _gravity_constant;}
	virtual void SetGravityConstant(Real val){_gravity_constant = val;}
	virtual void Add(Critter *critter){AddSpring(critter);AddGravity(critter);}
	virtual void AddSpring(Critter *critter)
		{_spring_pull_critter.Add(critter);}
	virtual void AddGravity(Critter *critter)
		{_gravity_pull_critter.Add(critter);}
	virtual void Move();
};

class PredatorPreyCritter: public Critter
{
protected:
	CArray <Critter*, Critter*> _predator_critter;
	CArray <Critter*, Critter*> _prey_critter;
	Real _predator_force;
	Real _prey_force;
	Real _repelling_force;
public:
	PredatorPreyCritter();
	virtual Real PredatorForce(){return _predator_force;}
	virtual void SetPredatorForce(Real val){_predator_force = val;}
	virtual Real PreyForce(){return _prey_force;}
	virtual void SetPreyForce(Real val){_prey_force = val;}
	virtual void AddPredator(Critter *critter){_predator_critter.Add(critter);}
	virtual void AddPrey(Critter *critter){_prey_critter.Add(critter);}
	virtual void Move();
};
#endif //CRITTER_H
